//--------------------------------------------------------------------------------------
// File: EmptyProject.fx
//
// The effect file for the EmptyProject sample.  
// 
// Copyright (c) Microsoft Corporation. All rights reserved.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
float appTime;  //App's time in seconds
float4x4 worldMatrix;  // World matrix for object
float4x4 worldViewProjection;	// World * View * Projection matrix
float alphamin;
float alphamax;
float4 light;
float4 view;

texture volumetex;
texture lookuptex;
texture screentex;

struct VS_INPUT 
{
   float3 Position : POSITION0;
   float3 Texcoord : TEXCOORD0;   
};

struct VS_OUTPUT 
{
   float4 Position : POSITION0;
   float3 Texcoord : TEXCOORD0;
};


VS_OUTPUT vs_main2( VS_INPUT Input )
{
   VS_OUTPUT Output;   
   float4 temp = mul( float4(Input.Position,1), worldMatrix );
   Output.Position = mul( temp, worldViewProjection );
   Output.Texcoord = Input.Texcoord;   
   return( Output );   
}

sampler3D baseMap = sampler_state{
	Texture = <volumetex>;
	MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler2D lookMap = sampler_state{
	Texture = <lookuptex>;
	MinFilter = POINT;
    MagFilter = POINT;
};

sampler2D screenMap = sampler_state{
	Texture = <screentex>;
	MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct PS_INPUT 
{
   float3 Texcoord : TEXCOORD0; 
};

float3 expand(float3 v){	
	return (v - 0.5f) * 2.0f;	
}

float4 ps_main2( PS_INPUT Input ) : COLOR0
{   
   float4 temp =  tex3D(baseMap, Input.Texcoord);    
   
   float4 outcolor = tex2D(lookMap, float2(temp.a, temp.a / 64));   
   
   float3 gradient = normalize(expand(temp.rgb));      
         
   float len = abs(gradient);
   
   float diffuse =  dot(gradient, light);	   
   
   if(diffuse < 0.0f) diffuse = 0.0f;
   
   if(outcolor.a > 0.0f){
	   if(outcolor.a < alphamin) outcolor.a = 0.0f;
	   else if(outcolor.a > alphamax) outcolor.a = outcolor.a;
	   else outcolor.a = outcolor.a * len;	   
   }  
   
   outcolor.rgb = 0.75f * outcolor.rgb + 0.5f * outcolor.rgb * diffuse; 
  
   return outcolor;    
   
}



//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------
technique RenderVolume2
{
    pass P0
    {   
        VertexShader = compile vs_2_0 vs_main2();
        PixelShader  = compile ps_2_0 ps_main2();       
    }
    
}
